#!/bin/python
import RPi.GPIO as GPIO # importeer de GPIO bibliotheek.
from time import sleep # importeer de time biblotheek voor tijdfuncties.

GPIO.setmode(GPIO.BCM) # Zet de pinmode op Broadcom SOC.
GPIO.setwarnings(False) # Zet waarschuwingen uit.

led=5 # GPIO pin als LED variabele declareren
pir=16 # GPIO pin als PIR variabele declareren
buzzer=18 # GPIO pin als BUZZER variabele declareren

GPIO.setup(buzzer, GPIO.OUT) # Zet de BUZZER pin als uitgang
GPIO.setup(led, GPIO.OUT) # Zet de LED pin als uitgang
GPIO.setup(pir, GPIO.IN) # Zet de PIR pin als ingang


while True:
    
    if GPIO.input(pir)== 0: # als GPIO pin van de PIR poort laag (0 = geen beweging) is
        print("PIR = 0, geen beweging...") # print tekst

        GPIO.output(led, 1) # zet de GPIO pin van de LED poort hoog (1 = licht aan)
        GPIO.output(buzzer,1) # zet de GPIO pin van de BUZZER poort hoog (1 = piepen)
        
        sleep(0.01) # 1/100 seconde wachten
        
        GPIO.output(led, 0) # zet de GPIO pin van de LED poort laag (0 = licht uit)
        GPIO.output(buzzer, 0) # zet de GPIO pin van de BUZZER poort laag (0 = piepen uit)
        
        sleep(1) # 2 seconden wachten
    
    else:
        print("PIR <> 0, wel beweging...") # print tekst
        
        GPIO.output(led, 1) # zet de GPIO pin van de LED poort hoog (1 = licht aan)
        GPIO.output(buzzer,1) # zet de GPIO pin van de BUZZER poort hoog (1 = piepen)
        
        sleep(0.01) # 1/100 seconde wachten
        
        GPIO.output(led, 0) # zet de GPIO pin van de LED poort laag (0 = licht uit)
        GPIO.output(buzzer, 0) # zet de GPIO pin van de BUZZER poort laag (0 = piepen uit)
        
        sleep(0.1) # 1/10 seconde wachten
